<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\AuthController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
// Auth Routes
Route::post('/register', [AuthController::class, 'register']);
//Route::get('/login', function() {
    //return response()->json(['message' => 'Gunakan POST untuk login'], 405);
//});
Route::post('/login', [AuthController::class, 'login']);


// Routes yang butuh login (token)
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::post('/logout', [AuthController::class, 'logout']);

    // CRUD users (opsional, jika kamu ingin tetap bisa akses)
    Route::apiResource('users', UserController::class);
});
