<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Slider;

class SliderController extends Controller
{
    public function create()
    {
        return view('slider.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image_file' => 'required|image|mimes:jpg,jpeg,png|max:2048',
            'link_target' => 'required|string|max:255',
        ]);

        // === STATIC URL ===
        $baseUrl = "https://isan.annamiroh.com/uploads/";

        // === PROSES UPLOAD FILE ===
        $file = $request->file('image_file');
        $filename = time() . '_' . $file->getClientOriginalName();
        $file->move(public_path('uploads'), $filename);

        // === FULL URL YANG DISIMPAN KE DB ===
        $imageUrl = $baseUrl . $filename;

        // === INSERT DATABASE ===
        DB::table('slider')->insert([
            'image_url'   => $imageUrl,
            'link_target' => $request->link_target,
            'created_at'  => now()
        ]);

        return redirect()->back()->with('success', 'Slider berhasil ditambahkan!');
    }
}
